/**
* \file: UsbKeyboardInput.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto - Test
*
* \author: M. Adachi / ADIT/SW / madachi@jp.adit-jv.com
*
* \copyright (c) 2013 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef USBKEYBOARD_H
#define USBKEYBOARD_H

#include <pthread.h>
#include <map>
#include <set>
#include "KeyboardHelper.h"
#include "aauto/AditInputSource.h"
#include "aauto/AditVideoSink.h"


namespace adit { namespace aauto {

enum eventTypeCode
{
    InputEventType = 1,
    VideoEventType,
    DeviceSelectionType,
    MediaActionType
};

enum keyEventCodeLocal
{
    VIDEO_NATIVE    = 1,
    VIDEO_PROJECTION,
    DEVICE_SEL_1,
    DEVICE_SEL_2,
    DEVICE_SEL_3,
    DEVICE_SEL_4,
    DEVICE_SEL_5,
    DEVICE_SEL_6,
    DEVICE_SEL_7,
    DEVICE_SEL_8,
    DEVICE_SEL_9,
    DEVICE_SEL_10,
    DEVICE_SEL_MAX,
    MEDIA_BROWSE_GET_NODE
};

class IKeyEventCallback
{
public:
    virtual ~IKeyEventCallback() {}
    virtual void onKeyEventVideo(uint32_t inInputCode) {}
    virtual void onKeyEventInput(uint32_t inInputCode, bool inPressed) {}
    virtual void onKeyEventDeviceSelection(uint32_t inInputCode) {}
    virtual void onKeyEventMediaAction(uint32_t inInputCode) {}
};
struct eventCodeBlock
{
    uint32_t        inputCode;
    eventTypeCode   typeCode;
};

class USBKeyboardInput : IKeyboardReceiver
{
public:
    ~USBKeyboardInput();

    bool init(IKeyEventCallback* inEventCallback);
    void shutdown();
    void OnKey(uint16_t inKeyCode, bool inPressed);
    void addSupportCode(eventTypeCode typeCode, uint16_t inKeyCode, uint32_t inInputCode);
    bool convertKeycode(uint16_t inKeyCode, eventTypeCode& outTypeCode, uint32_t& outInputCode);
    std::set<int32_t> getSetKeycodes() { return keycodes; }
    void display();

private:
    ::shared_ptr<AditInputSource> inputSource;
    ::shared_ptr<AditVideoSink>   videoSink;
    KeyboardHelper              keyboard;
    std::map<uint16_t, uint32_t>     keycode_map;
    IKeyEventCallback*              eventCallback;
    std::map<uint16_t, eventCodeBlock>   inputMap;
    std::set<int32_t>                    keycodes;
};

} } // namespace adit { namespace aauto

#endif // USBKEYBOARD_H
